/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.treedata;

public record BranchShapeState(byte down, byte up, byte north, byte south, byte west, byte east, byte core) {
    private static final int[] BLOCK_START = new int[8];
    public static final int TOTAL_STATES;

    public int toIndex() {
        int base = this.core + 1;
        int local = this.down;
        local = local * base + this.up;
        local = local * base + this.north;
        local = local * base + this.south;
        local = local * base + this.west;
        local = local * base + this.east;
        return BLOCK_START[this.core] + local;
    }

    public static BranchShapeState fromArray(byte[] radii) {
        return new BranchShapeState(radii[0], radii[1], radii[2], radii[3], radii[4], radii[5], radii[6]);
    }

    static {
        int sum = 0;
        for (int core = 1; core < 8; ++core) {
            int size = (int)Math.pow(core + 1, 6.0);
            BranchShapeState.BLOCK_START[core] = sum;
            sum += size;
        }
        TOTAL_STATES = sum;
    }
}

